module Test_virtnetworkd =
   let conf = "unix_sock_group = \"libvirt\"
unix_sock_ro_perms = \"0777\"
unix_sock_rw_perms = \"0770\"
unix_sock_admin_perms = \"0700\"
unix_sock_dir = \"/var/run/libvirt\"
auth_unix_ro = \"none\"
auth_unix_rw = \"none\"
access_drivers = [ \"polkit\" ]
sasl_allowed_username_list = [\"joe@EXAMPLE.COM\", \"fred@EXAMPLE.COM\" ]
max_clients = 5000
max_queued_clients = 1000
max_anonymous_clients = 20
min_workers = 5
max_workers = 20
prio_workers = 5
max_client_requests = 5
admin_min_workers = 1
admin_max_workers = 5
admin_max_clients = 5
admin_max_queued_clients = 5
admin_max_client_requests = 5
log_level = 3
log_filters=\"1:qemu 1:libvirt 4:object 4:json 4:event 1:util\"
log_outputs=\"3:syslog:virtnetworkd\"
audit_level = 2
audit_logging = 1
host_uuid = \"00000000-0000-0000-0000-000000000000\"
host_uuid_source = \"smbios\"
keepalive_interval = 5
keepalive_count = 5
keepalive_required = 1
admin_keepalive_required = 1
admin_keepalive_interval = 5
admin_keepalive_count = 5
ovs_timeout = 5
"

   test Virtnetworkd.lns get conf =
        { "unix_sock_group" = "libvirt" }
        { "unix_sock_ro_perms" = "0777" }
        { "unix_sock_rw_perms" = "0770" }
        { "unix_sock_admin_perms" = "0700" }
        { "unix_sock_dir" = "/var/run/libvirt" }
        { "auth_unix_ro" = "none" }
        { "auth_unix_rw" = "none" }
        { "access_drivers"
             { "1" = "polkit" }
        }
        { "sasl_allowed_username_list"
             { "1" = "joe@EXAMPLE.COM" }
             { "2" = "fred@EXAMPLE.COM" }
        }
        { "max_clients" = "5000" }
        { "max_queued_clients" = "1000" }
        { "max_anonymous_clients" = "20" }
        { "min_workers" = "5" }
        { "max_workers" = "20" }
        { "prio_workers" = "5" }
        { "max_client_requests" = "5" }
        { "admin_min_workers" = "1" }
        { "admin_max_workers" = "5" }
        { "admin_max_clients" = "5" }
        { "admin_max_queued_clients" = "5" }
        { "admin_max_client_requests" = "5" }
        { "log_level" = "3" }
        { "log_filters" = "1:qemu 1:libvirt 4:object 4:json 4:event 1:util" }
        { "log_outputs" = "3:syslog:virtnetworkd" }
        { "audit_level" = "2" }
        { "audit_logging" = "1" }
        { "host_uuid" = "00000000-0000-0000-0000-000000000000" }
        { "host_uuid_source" = "smbios" }
        { "keepalive_interval" = "5" }
        { "keepalive_count" = "5" }
        { "keepalive_required" = "1" }
        { "admin_keepalive_required" = "1" }
        { "admin_keepalive_interval" = "5" }
        { "admin_keepalive_count" = "5" }
        { "ovs_timeout" = "5" }
