"""User/Group passwordless sudo, sudo commands allowlist

Revision ID: dc143ce20fcd
Revises: ae629228373b
Create Date: 2021-02-23 11:54:59.512053+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'dc143ce20fcd'
down_revision = 'ae629228373b'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('account_bsdgroups', schema=None) as batch_op:
        batch_op.add_column(sa.Column('bsdgrp_sudo_commands', sa.TEXT(), nullable=False, server_default='[]'))
        batch_op.add_column(sa.Column('bsdgrp_sudo_nopasswd', sa.Boolean(), nullable=False, server_default='0'))

    with op.batch_alter_table('account_bsdusers', schema=None) as batch_op:
        batch_op.add_column(sa.Column('bsdusr_sudo_commands', sa.TEXT(), nullable=False, server_default='[]'))
        batch_op.add_column(sa.Column('bsdusr_sudo_nopasswd', sa.Boolean(), nullable=False, server_default='0'))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('account_bsdusers', schema=None) as batch_op:
        batch_op.drop_column('bsdusr_sudo_nopasswd')
        batch_op.drop_column('bsdusr_sudo_commands')

    with op.batch_alter_table('account_bsdgroups', schema=None) as batch_op:
        batch_op.drop_column('bsdgrp_sudo_nopasswd')
        batch_op.drop_column('bsdgrp_sudo_commands')

    # ### end Alembic commands ###
