"""Simplify SMB shares

Revision ID: bc290fddc888
Revises: 536cbfca20e6
Create Date: 2020-01-16 19:16:53.973957+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'bc290fddc888'
down_revision = '536cbfca20e6'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    """
    Move VFS objects into new boolean values. If users have a non-standard
    set, append them as auxilary parameters to the SMB share to preseve
    existing configuration. Same for other columns that are being dropped.
    This will preserve existing share behavior post-migration.
    """
    standard_vfs_objects = ['ixnas', 'streams_xattr', 'fruit', 'catia']
    fruit_enabled = False
    has_acl = True
    has_streams =False
    has_catia = False
    set_durable = True
    with op.batch_alter_table('services_cifs', schema=None) as batch_op:
        batch_op.add_column(sa.Column('cifs_srv_aapl_extensions', sa.Boolean(), nullable=True))
        batch_op.drop_column('cifs_srv_aio_enable')
        batch_op.drop_column('cifs_srv_aio_rs')
        batch_op.drop_column('cifs_srv_aio_ws')

    with op.batch_alter_table('sharing_cifs_share', schema=None) as batch_op:
        batch_op.add_column(sa.Column('cifs_purpose', sa.String(length=255), nullable=True))
        batch_op.add_column(sa.Column('cifs_acl', sa.Boolean(), nullable=True))
        batch_op.add_column(sa.Column('cifs_aapl_name_mangling', sa.Boolean(), nullable=True))
        batch_op.add_column(sa.Column('cifs_path_suffix', sa.String(length=255), nullable=True))
        batch_op.add_column(sa.Column('cifs_streams', sa.Boolean(), nullable=True))
        batch_op.add_column(sa.Column('cifs_durablehandle', sa.Boolean(), nullable=True))

    conn = op.get_bind()
    smb_shares = [dict(row) for row in conn.execute("SELECT * FROM sharing_cifs_share").fetchall()]
    for share in smb_shares:
        aux_params = share.get('cifs_auxsmbconf', '').split('\n')
        vfs_objects = share.get('cifs_vfsobjects', '')
        has_nondefault_vfs_objects = False
        aux_updated = False

        for v in vfs_objects.split(','):
            if v not in standard_vfs_objects:
                set_durable = False
                has_nondefault_vfs_objects = True

            if v == 'fruit':
                fruit_enabled = True
            if v == 'streams_xattr':
                has_streams = True
            if v == 'noacl':
                has_acl = False
            if v == 'catia':
                has_catia = True

        if share['cifs_timemachine']:
            fruit_enabled = True

        if share['cifs_showhiddenfiles']:
            aux_params.append('hide dot files = no')

        if share['cifs_guestonly']:
            aux_params.append('guest only = yes')

        if has_nondefault_vfs_objects:
            aux_params.append(f"vfs objects = {vfs_objects.replace(',', ' ')}")

        new_aux = '\n'.join(aux_params)
        conn.execute("UPDATE sharing_cifs_share SET cifs_acl = :acl, cifs_streams = :streams, "
                     "cifs_aapl_name_mangling = :catia, cifs_durablehandle= :durable, "
                     "cifs_path_suffix = '', cifs_auxsmbconf = :aux, cifs_purpose = 'NO_PRESET' "
                     "WHERE id=:share_id", acl=has_acl, streams=has_streams, catia=has_catia,
                     durable=set_durable, aux=new_aux, share_id=share['id'])

    op.execute(f"UPDATE services_cifs SET cifs_srv_aapl_extensions = {fruit_enabled}")

    with op.batch_alter_table('sharing_cifs_share', schema=None) as batch_op:
        batch_op.drop_column('cifs_vfsobjects')
        batch_op.drop_column('cifs_showhiddenfiles')
        batch_op.drop_column('cifs_guestonly')

    with op.batch_alter_table('sharing_cifs_share', schema=None) as batch_op:
        batch_op.alter_column('cifs_purpose', nullable=False)
        batch_op.alter_column('cifs_acl', nullable=False)
        batch_op.alter_column('cifs_streams', nullable=False)
        batch_op.alter_column('cifs_path_suffix', nullable=False)
        batch_op.alter_column('cifs_aapl_name_mangling', nullable=False)
        batch_op.alter_column('cifs_durablehandle', nullable=False)

    with op.batch_alter_table('services_cifs', schema=None) as batch_op:
        batch_op.alter_column('cifs_srv_aapl_extensions', nullable=False)

    # ### end Alembic commands ###
