"""OpenVPN client and server

Revision ID: 115caec86b91
Revises: 8b5d36242d44
Create Date: 2019-11-19 20:41:34.620255+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '115caec86b91'
down_revision = '8b5d36242d44'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('services_openvpnclient',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('port', sa.Integer(), nullable=False),
    sa.Column('protocol', sa.String(length=4), nullable=False),
    sa.Column('device_type', sa.String(length=4), nullable=False),
    sa.Column('nobind', sa.Boolean(), nullable=False),
    sa.Column('authentication_algorithm', sa.String(length=32), nullable=True),
    sa.Column('tls_crypt_auth', sa.Text(), nullable=True),
    sa.Column('cipher', sa.String(length=32), nullable=True),
    sa.Column('compression', sa.String(length=32), nullable=True),
    sa.Column('additional_parameters', sa.Text(), nullable=False),
    sa.Column('client_certificate_id', sa.Integer(), nullable=True),
    sa.Column('root_ca_id', sa.Integer(), nullable=True),
    sa.Column('remote', sa.String(length=120), nullable=False),
    sa.ForeignKeyConstraint(['client_certificate_id'], ['system_certificate.id'], name=op.f('fk_services_openvpnclient_client_certificate_id_system_certificate')),
    sa.ForeignKeyConstraint(['root_ca_id'], ['system_certificateauthority.id'], name=op.f('fk_services_openvpnclient_root_ca_id_system_certificateauthority')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_services_openvpnclient'))
    )
    with op.batch_alter_table('services_openvpnclient', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_services_openvpnclient_client_certificate_id'), ['client_certificate_id'], unique=False)
        batch_op.create_index(batch_op.f('ix_services_openvpnclient_root_ca_id'), ['root_ca_id'], unique=False)

    op.create_table('services_openvpnserver',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('port', sa.Integer(), nullable=False),
    sa.Column('protocol', sa.String(length=4), nullable=False),
    sa.Column('device_type', sa.String(length=4), nullable=False),
    sa.Column('authentication_algorithm', sa.String(length=32), nullable=True),
    sa.Column('tls_crypt_auth', sa.Text(), nullable=True),
    sa.Column('cipher', sa.String(length=32), nullable=True),
    sa.Column('compression', sa.String(length=32), nullable=True),
    sa.Column('additional_parameters', sa.Text(), nullable=False),
    sa.Column('server_certificate_id', sa.Integer(), nullable=True),
    sa.Column('root_ca_id', sa.Integer(), nullable=True),
    sa.Column('server', sa.String(length=45), nullable=False),
    sa.Column('topology', sa.String(length=16), nullable=True),
    sa.Column('netmask', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['root_ca_id'], ['system_certificateauthority.id'], name=op.f('fk_services_openvpnserver_root_ca_id_system_certificateauthority')),
    sa.ForeignKeyConstraint(['server_certificate_id'], ['system_certificate.id'], name=op.f('fk_services_openvpnserver_server_certificate_id_system_certificate')),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_services_openvpnserver'))
    )
    with op.batch_alter_table('services_openvpnserver', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_services_openvpnserver_root_ca_id'), ['root_ca_id'], unique=False)
        batch_op.create_index(batch_op.f('ix_services_openvpnserver_server_certificate_id'), ['server_certificate_id'], unique=False)

    op.execute("INSERT INTO services_services (srv_service, srv_enable) VALUES ('openvpn_client', 0)")
    op.execute("INSERT INTO services_services (srv_service, srv_enable) VALUES ('openvpn_server', 0)")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('services_openvpnserver', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_services_openvpnserver_server_certificate_id'))
        batch_op.drop_index(batch_op.f('ix_services_openvpnserver_root_ca_id'))

    op.drop_table('services_openvpnserver')
    with op.batch_alter_table('services_openvpnclient', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_services_openvpnclient_root_ca_id'))
        batch_op.drop_index(batch_op.f('ix_services_openvpnclient_client_certificate_id'))

    op.drop_table('services_openvpnclient')
    # ### end Alembic commands ###
