"""Drop nfs_share_path MtM

Revision ID: a3423860aea0
Revises: 0d545b21e189
Create Date: 2019-09-27 07:44:47.071979+00:00

"""
import json
import operator

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'a3423860aea0'
down_revision = '0d545b21e189'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('sharing_nfs_share', sa.Column('nfs_paths', sa.TEXT(), nullable=True))

    conn = op.get_bind()
    for share_id, in conn.execute("SELECT id FROM sharing_nfs_share").fetchall():
        paths = list(map(operator.itemgetter(0),
                         conn.execute("SELECT path FROM sharing_nfs_share_path WHERE share_id = ?", [share_id])))
        conn.execute("UPDATE sharing_nfs_share SET nfs_paths = ? WHERE id = ?", [json.dumps(paths), share_id])

    with op.batch_alter_table('sharing_nfs_share', schema=None) as batch_op:
        batch_op.alter_column('nfs_paths',
               existing_type=sa.TEXT(),
               nullable=False)

    op.drop_table('sharing_nfs_share_path')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('sharing_nfs_share', 'nfs_paths')
    op.create_table('sharing_nfs_share_path',
    sa.Column('id', sa.INTEGER(), nullable=False),
    sa.Column('share_id', sa.INTEGER(), nullable=False),
    sa.Column('path', sa.VARCHAR(length=255), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###
