require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_SYSTM_H_)) {
    eval 'sub _SYS_SYSTM_H_ () {1;}' unless defined(&_SYS_SYSTM_H_);
    require 'sys/cdefs.ph';
    require 'machine/atomic.ph';
    require 'machine/cpufunc.ph';
    require 'sys/callout.ph';
    require 'sys/kassert.ph';
    require 'sys/queue.ph';
    require 'sys/stdint.ph';
    if(defined(&_KERNEL)) {
	eval("sub VM_GUEST_NO () { 0; }") unless defined(&VM_GUEST_NO);
	eval("sub VM_GUEST_VM () { 1; }") unless defined(&VM_GUEST_VM);
	eval("sub VM_GUEST_XEN () { 2; }") unless defined(&VM_GUEST_XEN);
	eval("sub VM_GUEST_HV () { 3; }") unless defined(&VM_GUEST_HV);
	eval("sub VM_GUEST_VMWARE () { 4; }") unless defined(&VM_GUEST_VMWARE);
	eval("sub VM_GUEST_KVM () { 5; }") unless defined(&VM_GUEST_KVM);
	eval("sub VM_GUEST_BHYVE () { 6; }") unless defined(&VM_GUEST_BHYVE);
	eval("sub VM_GUEST_VBOX () { 7; }") unless defined(&VM_GUEST_VBOX);
	eval("sub VM_GUEST_PARALLELS () { 8; }") unless defined(&VM_GUEST_PARALLELS);
	eval("sub VM_LAST () { 9; }") unless defined(&VM_LAST);
    }
    eval 'sub __read_mostly () { &__section(".data.read_mostly");}' unless defined(&__read_mostly);
    eval 'sub __read_frequently () { &__section(".data.read_frequently");}' unless defined(&__read_frequently);
    eval 'sub __exclusive_cache_line () { &__aligned( &CACHE_LINE_SIZE)  &__section(".data.exclusive_cache_line");}' unless defined(&__exclusive_cache_line);
    if(defined(&_STANDALONE)) {
    }
    if(defined(&_KERNEL)) {
	require 'sys/param.ph';
	require 'sys/pcpu.ph';
	require 'sys/kpilite.ph';
	if(defined(&__LP64__)) {
	    eval 'sub IOSIZE_MAX () { &iosize_max();}' unless defined(&IOSIZE_MAX);
	    eval 'sub DEVFS_IOSIZE_MAX () { &devfs_iosize_max();}' unless defined(&DEVFS_IOSIZE_MAX);
	} else {
	    eval 'sub IOSIZE_MAX () { &SSIZE_MAX;}' unless defined(&IOSIZE_MAX);
	    eval 'sub DEVFS_IOSIZE_MAX () { &SSIZE_MAX;}' unless defined(&DEVFS_IOSIZE_MAX);
	}
	eval 'sub HASH_NOWAIT () {0x1;}' unless defined(&HASH_NOWAIT);
	eval 'sub HASH_WAITOK () {0x2;}' unless defined(&HASH_WAITOK);
	if(defined(&KLD_MODULE) || defined(&KTR_CRITICAL) || !defined(&_KERNEL) || defined(&GENOFFSET)) {
	    eval 'sub critical_enter () {
	        eval q( &critical_enter_KBI());
	    }' unless defined(&critical_enter);
	    eval 'sub critical_exit () {
	        eval q( &critical_exit_KBI());
	    }' unless defined(&critical_exit);
	} else {
	    eval 'sub critical_enter {
	        my($void) = @_;
    		eval q({ \'struct thread_lite\' * &td;  &td =  &curthread;  ($td->{td_critnest})++;  &atomic_interrupt_fence(); });
	    }' unless defined(&critical_enter);
	    eval 'sub critical_exit {
	        my($void) = @_;
    		eval q({ \'struct thread_lite\' * &td;  &td =  &curthread;  &KASSERT( ($td->{td_critnest}) != 0, (\\"critical_exit: td_critnest == 0\\"));  &atomic_interrupt_fence();  ($td->{td_critnest})--;  &atomic_interrupt_fence();  &if ( &__predict_false( ($td->{td_owepreempt})))  &critical_exit_preempt(); });
	    }' unless defined(&critical_exit);
	}
	if(defined(&EARLY_PRINTF)) {
	}
	eval 'sub HD_COLUMN_MASK () {0xff;}' unless defined(&HD_COLUMN_MASK);
	eval 'sub HD_DELIM_MASK () {0xff00;}' unless defined(&HD_DELIM_MASK);
	eval 'sub HD_OMIT_COUNT () {(1<< 16);}' unless defined(&HD_OMIT_COUNT);
	eval 'sub HD_OMIT_HEX () {(1<< 17);}' unless defined(&HD_OMIT_HEX);
	eval 'sub HD_OMIT_CHARS () {(1<< 18);}' unless defined(&HD_OMIT_CHARS);
	eval 'sub ovbcopy {
	    my($f, $t, $l) = @_;
    	    eval q( &bcopy(($f), ($t), ($l)));
	}' unless defined(&ovbcopy);
	if(defined(&SAN_NEEDS_INTERCEPTORS)) {
	    eval 'sub SAN_INTERCEPTOR {
	        my($func) = @_;
    		eval q( &__CONCAT( &SAN_INTERCEPTOR_PREFIX,  &__CONCAT( &_, $func)));
	    }' unless defined(&SAN_INTERCEPTOR);
	    unless(defined(&SAN_RUNTIME)) {
		eval 'sub bcopy {
		    my($from, $to, $len) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memmove)(($to), ($from), ($len)));
		}' unless defined(&bcopy);
		eval 'sub bzero {
		    my($buf, $len) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memset)(($buf), 0, ($len)));
		}' unless defined(&bzero);
		eval 'sub bcmp {
		    my($b1, $b2, $len) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memcmp)(($b1), ($b2), ($len)));
		}' unless defined(&bcmp);
		eval 'sub memset {
		    my($buf, $c, $len) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memset)(($buf), ($c), ($len)));
		}' unless defined(&memset);
		eval 'sub memcpy {
		    my($to, $from, $len) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memcpy)(($to), ($from), ($len)));
		}' unless defined(&memcpy);
		eval 'sub memmove {
		    my($dest, $src, $n) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memmove)(($dest), ($src), ($n)));
		}' unless defined(&memmove);
		eval 'sub memcmp {
		    my($b1, $b2, $len) = @_;
    		    eval q( &SAN_INTERCEPTOR( &memcmp)(($b1), ($b2), ($len)));
		}' unless defined(&memcmp);
	    }
	} else {
	    eval 'sub bcopy {
	        my($from, $to, $len) = @_;
    		eval q( &__builtin_memmove(($to), ($from), ($len)));
	    }' unless defined(&bcopy);
	    eval 'sub bzero {
	        my($buf, $len) = @_;
    		eval q( &__builtin_memset(($buf), 0, ($len)));
	    }' unless defined(&bzero);
	    eval 'sub bcmp {
	        my($b1, $b2, $len) = @_;
    		eval q( &__builtin_memcmp(($b1), ($b2), ($len)));
	    }' unless defined(&bcmp);
	    eval 'sub memset {
	        my($buf, $c, $len) = @_;
    		eval q( &__builtin_memset(($buf), ($c), ($len)));
	    }' unless defined(&memset);
	    eval 'sub memcpy {
	        my($to, $from, $len) = @_;
    		eval q( &__builtin_memcpy(($to), ($from), ($len)));
	    }' unless defined(&memcpy);
	    eval 'sub memmove {
	        my($dest, $src, $n) = @_;
    		eval q( &__builtin_memmove(($dest), ($src), ($n)));
	    }' unless defined(&memmove);
	    eval 'sub memcmp {
	        my($b1, $b2, $len) = @_;
    		eval q( &__builtin_memcmp(($b1), ($b2), ($len)));
	    }' unless defined(&memcmp);
	}
	eval 'sub bzero_early {
	    my($buf, $len) = @_;
    	    eval q( &memset_early(($buf), 0, ($len)));
	}' unless defined(&bzero_early);
	eval 'sub bcopy_early {
	    my($from, $to, $len) = @_;
    	    eval q( &memmove_early(($to), ($from), ($len)));
	}' unless defined(&bcopy_early);
	eval 'sub copystr {
	    my($src, $dst, $len, $outlen) = @_;
    	    eval q(({ \'size_t\'  &__r,  &__len, * &__outlen;  &__len = ($len);  &__outlen = ($outlen);  &__r =  &strlcpy(($dst), ($src),  &__len);  &if ( &__outlen !=  &NULL) * &__outlen = (( &__r >=  &__len) ?  &__len :  &__r + 1); (( &__r >=  &__len) ?  &ENAMETOOLONG : 0); }));
	}' unless defined(&copystr);
	if(defined(&SAN_NEEDS_INTERCEPTORS)) {
	    unless(defined(&SAN_RUNTIME)) {
		eval 'sub copyin {
		    my($u, $k, $l) = @_;
    		    eval q( &SAN_INTERCEPTOR( &copyin)(($u), ($k), ($l)));
		}' unless defined(&copyin);
		eval 'sub copyinstr {
		    my($u, $k, $l, $lc) = @_;
    		    eval q( &SAN_INTERCEPTOR( &copyinstr)(($u), ($k), ($l), ($lc)));
		}' unless defined(&copyinstr);
		eval 'sub copyout {
		    my($k, $u, $l) = @_;
    		    eval q( &SAN_INTERCEPTOR( &copyout)(($k), ($u), ($l)));
		}' unless defined(&copyout);
	    }
	}
	eval 'sub GETENV_UNSIGNED () { &false;}' unless defined(&GETENV_UNSIGNED);
	eval 'sub GETENV_SIGNED () { &true;}' unless defined(&GETENV_SIGNED);
	require 'sys/libkern.ph';
	eval 'sub msleep {
	    my($chan, $mtx, $pri, $wmesg, $timo) = @_;
    	    eval q( &_sleep(($chan), ($mtx)-> &lock_object, ($pri), ($wmesg),  &tick_sbt * ($timo), 0,  &C_HARDCLOCK));
	}' unless defined(&msleep);
	eval 'sub msleep_sbt {
	    my($chan, $mtx, $pri, $wmesg, $bt, $pr, $flags) = @_;
    	    eval q( &_sleep(($chan), ($mtx)-> &lock_object, ($pri), ($wmesg), ($bt), ($pr), ($flags)));
	}' unless defined(&msleep_sbt);
	eval 'sub msleep_spin {
	    my($chan, $mtx, $wmesg, $timo) = @_;
    	    eval q( &msleep_spin_sbt(($chan), ($mtx), ($wmesg),  &tick_sbt * ($timo), 0,  &C_HARDCLOCK));
	}' unless defined(&msleep_spin);
	eval 'sub pause {
	    my($wmesg,$timo) = @_;
    	    eval q({ ( &pause_sbt($wmesg,  &tick_sbt * $timo, 0,  &C_HARDCLOCK)); });
	}' unless defined(&pause);
	eval 'sub pause_sig {
	    my($wmesg, $timo) = @_;
    	    eval q( &pause_sbt(($wmesg),  &tick_sbt * ($timo), 0,  &C_HARDCLOCK |  &C_CATCH));
	}' unless defined(&pause_sig);
	eval 'sub tsleep {
	    my($chan, $pri, $wmesg, $timo) = @_;
    	    eval q( &_sleep(($chan),  &NULL, ($pri), ($wmesg),  &tick_sbt * ($timo), 0,  &C_HARDCLOCK));
	}' unless defined(&tsleep);
	eval 'sub tsleep_sbt {
	    my($chan, $pri, $wmesg, $bt, $pr, $flags) = @_;
    	    eval q( &_sleep(($chan),  &NULL, ($pri), ($wmesg), ($bt), ($pr), ($flags)));
	}' unless defined(&tsleep_sbt);
	if(defined(&__LP64__)) {
	}
	eval 'sub UNR_NO_MTX () {(( &void *)( &uintptr_t)-1);}' unless defined(&UNR_NO_MTX);
	unless(defined(&__LP64__)) {
	    eval 'sub UNR64_LOCKED () {1;}' unless defined(&UNR64_LOCKED);
	}
	eval 'sub new_unrhdr64 {
	    my($unr64,$low) = @_;
    	    eval q({  ($unr64->{counter}) = $low; });
	}' unless defined(&new_unrhdr64);
	if(defined(&UNR64_LOCKED)) {
	} else {
	    eval 'sub alloc_unr64 {
	        my($unr64) = @_;
    		eval q({ ( &atomic_fetchadd_64( ($unr64->{counter}), 1)); });
	    }' unless defined(&alloc_unr64);
	}
	if(defined(&NO_OBSOLETE_CODE)) {
	    eval 'sub __gone_ok {
	        my($m, $msg) = @_;
    		eval q( &_Static_assert($m <  &P_OSREL_MAJOR( &__FreeBSD_version)), \\"Obsolete code: \\" $msg););
	    }' unless defined(&__gone_ok);
	} else {
	    eval 'sub __gone_ok {
	        my($m, $msg) = @_;
    		eval q();
	    }' unless defined(&__gone_ok);
	}
	eval 'sub gone_in {
	    my($major, $msg) = @_;
    	    eval q( &__gone_ok($major, $msg)  &_gone_in($major, $msg));
	}' unless defined(&gone_in);
	eval 'sub gone_in_dev {
	    my($dev, $major, $msg) = @_;
    	    eval q( &__gone_ok($major, $msg)  &_gone_in_dev($dev, $major, $msg));
	}' unless defined(&gone_in_dev);
	if(defined(&INVARIANTS) || defined(&WITNESS)) {
	    eval 'sub __diagused () {1;}' unless defined(&__diagused);
	} else {
	    eval 'sub __diagused () { &__unused;}' unless defined(&__diagused);
	}
    }
}
1;
