# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2019-03-07 03:54
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import freenasUI.freeadmin.models.fields


def delete_alerts(apps, schemaeditor):
    Alert = apps.get_model('system', 'Alert')
    Alert.objects.all().delete()


class Migration(migrations.Migration):

    dependencies = [
        ('system', '0038_merge_20190226_1008'),
    ]

    operations = [
        migrations.DeleteModel(
            name='AlertDefaultSettings',
        ),
        migrations.CreateModel(
            name='AlertClasses',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('classes', freenasUI.freeadmin.models.fields.DictField(blank=True)),
            ],
            options={
                'verbose_name': 'Alerts',
            },
        ),
        migrations.RunSQL("INSERT INTO system_alertclasses (classes) values ('{}')"),

        migrations.RunPython(
            delete_alerts,
        ),
        migrations.AddField(
            model_name='alert',
            name='uuid',
            field=models.TextField(),
        ),
        migrations.AddField(
            model_name='alert',
            name='klass',
            field=models.TextField(),
        ),
        migrations.RenameField(
            model_name='alert',
            old_name='title',
            new_name='text',
        ),
        migrations.RemoveField(
            model_name='alert',
            name='level',
        ),
        migrations.AlterUniqueTogether(
            name='alert',
            unique_together=set([('node', 'klass', 'key')]),
        ),

        migrations.RemoveField(
            model_name='alertservice',
            name='settings',
        ),
        migrations.AddField(
            model_name='alertservice',
            name='level',
            field=models.CharField(default='WARNING', max_length=20, verbose_name='Level'),
        ),
    ]
