# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2017-12-08 04:24
from __future__ import unicode_literals

from django.db import migrations
import freenasUI.freeadmin.models.fields
import os


KBDBASE = '/usr/share/vt/keymaps'


def syscons_to_vt(apps, schema_editor):
    settings = apps.get_model('system', 'Settings').objects.all()
    for o in settings:
        if not o.stg_kbdmap:
            continue

        if os.path.exists(f'{KBDBASE}/{o.stg_kbdmap}.kbd'):
            continue

        if 'iso.' in o.stg_kbdmap:
            new = o.stg_kbdmap.replace('iso.', '')
            if os.path.exists(f'{KBDBASE}/{new}.kbd'):
                o.stg_kbdmap = new
                o.save()
                continue


class Migration(migrations.Migration):

    dependencies = [
        ('system', '0009_auto_20171023_2159'),
    ]

    operations = [
        migrations.RunPython(syscons_to_vt),
    ]
