# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2019-08-09 11:37
from __future__ import unicode_literals

import datetime
from django.db import migrations, models


def set_repl_properties(apps, schema_editor):
    Replication = apps.get_model('storage', 'Replication')
    for repl in Replication.objects.all():
        repl.repl_properties = repl.repl_retention_policy == "SOURCE"
        repl.save()


class Migration(migrations.Migration):

    dependencies = [
        ('storage', '0021_auto_20190616_0550'),
    ]

    operations = [
        migrations.AddField(
            model_name='replication',
            name='repl_properties',
            field=models.BooleanField(default=True, verbose_name='Send dataset properties along with snapshots'),
        ),
        migrations.RunPython(set_repl_properties),
    ]
