# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2019-03-20 11:37
from __future__ import unicode_literals

from django.db import migrations, models


def set_repl_name(apps, schema_editor):
    Replication = apps.get_model('storage', 'Replication')
    for repl in Replication.objects.all():
        repl.repl_name = "%s -> %s:%s" % (
            ". ".join(repl.repl_source_datasets),
            repl.repl_ssh_credentials.name if repl.repl_ssh_credentials else "-",
            repl.repl_target_dataset,
        )
        repl.save()


class Migration(migrations.Migration):

    dependencies = [
        ('storage', '0018_auto_20190313_0841'),
    ]

    operations = [
        migrations.AddField(
            model_name='replication',
            name='repl_name',
            field=models.CharField(default='', max_length=120, verbose_name='Name'),
            preserve_default=False,
        ),
        migrations.RunPython(set_repl_name),
    ]
