# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-05-25 18:57
from __future__ import unicode_literals

from datetime import datetime, timedelta
from django.db import migrations, models


def set_expiretime(apps, schema_editor):
    """
    Disks that are currently disabled get a expire time
    """
    Disk = apps.get_model('storage', 'Disk')
    Disk.objects.filter(disk_enabled=False).update(disk_expiretime=datetime.utcnow() + timedelta(days=7))


class Migration(migrations.Migration):

    dependencies = [
        ('storage', '0001_initial'),
    ]

    operations = [
        migrations.AddField(
            model_name='disk',
            name='disk_expiretime',
            field=models.DateTimeField(editable=False, null=True),
        ),
        migrations.RunPython(set_expiretime),
        migrations.RemoveField(
            model_name='disk',
            name='disk_enabled',
        ),
    ]
