# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2016-12-27 21:41


import datetime
from django.db import migrations, models
import django.db.models.deletion
import freenasUI.freeadmin.models.fields
from freenasUI import choices


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Disk',
            fields=[
                ('disk_identifier', models.CharField(editable=False, max_length=42, primary_key=True, serialize=False, verbose_name='Identifier')),
                ('disk_name', models.CharField(max_length=120, verbose_name='Name')),
                ('disk_subsystem', models.CharField(default='', editable=False, max_length=10)),
                ('disk_number', models.IntegerField(default=1, editable=False)),
                ('disk_serial', models.CharField(blank=True, max_length=30, verbose_name='Serial')),
                ('disk_size', models.CharField(blank=True, editable=False, max_length=20, verbose_name='Disk Size')),
                ('disk_multipath_name', models.CharField(blank=True, editable=False, max_length=30, verbose_name='Multipath name')),
                ('disk_multipath_member', models.CharField(blank=True, editable=False, max_length=30, verbose_name='Multipath member')),
                ('disk_description', models.CharField(blank=True, max_length=120, verbose_name='Description')),
                ('disk_transfermode', models.CharField(choices=choices.TRANSFERMODE_CHOICES, default='Auto', max_length=120, verbose_name='Transfer Mode')),
                ('disk_hddstandby', models.CharField(choices=choices.HDDSTANDBY_CHOICES, default='Always On', max_length=120, verbose_name='HDD Standby')),
                ('disk_advpowermgmt', models.CharField(choices=choices.ADVPOWERMGMT_CHOICES, default='Disabled', max_length=120, verbose_name='Advanced Power Management')),
                ('disk_acousticlevel', models.CharField(choices=choices.ACOUSTICLVL_CHOICES, default='Disabled', max_length=120, verbose_name='Acoustic Level')),
                ('disk_togglesmart', models.BooleanField(default=True, verbose_name='Enable S.M.A.R.T.')),
                ('disk_smartoptions', models.CharField(blank=True, max_length=120, verbose_name='S.M.A.R.T. extra options')),
                ('disk_enabled', models.BooleanField(default=True, editable=False)),
            ],
            options={
                'ordering': ['disk_subsystem', 'disk_number'],
                'verbose_name': 'Disk',
                'verbose_name_plural': 'Disks',
            },
        ),
        migrations.CreateModel(
            name='EncryptedDisk',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('encrypted_provider', models.CharField(max_length=120, unique=True, verbose_name='Underlying provider')),
                ('encrypted_disk', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='storage.Disk')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Replication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('repl_filesystem', models.CharField(blank=True, max_length=150, verbose_name='Volume/Dataset')),
                ('repl_lastsnapshot', models.CharField(blank=True, editable=False, max_length=120, verbose_name='Last snapshot sent to remote side')),
                ('repl_zfs', models.CharField(help_text='This should be the name of the ZFS filesystem on remote side. eg: Volumename/Datasetname not the mountpoint or filesystem path', max_length=120, verbose_name='Remote ZFS Volume/Dataset')),
                ('repl_userepl', models.BooleanField(default=False, verbose_name="Recursively replicate child dataset's snapshots")),
                ('repl_followdelete', models.BooleanField(default=False, verbose_name='Delete stale snapshots on remote system')),
                ('repl_compression', models.CharField(choices=choices.Repl_CompressionChoices, default='lz4', max_length=5, verbose_name='Replication Stream Compression')),
                ('repl_limit', models.IntegerField(default=0, help_text='Limit the replication speed. Unit in kilobytes/seconds. 0 = unlimited.', verbose_name='Limit (kB/s)')),
                ('repl_begin', models.TimeField(default=datetime.time(0, 0), help_text='Do not start replication before', verbose_name='Begin')),
                ('repl_end', models.TimeField(default=datetime.time(23, 59), help_text='Do not start replication after', verbose_name='End')),
                ('repl_enabled', models.BooleanField(default=True, help_text='Disabling will not stop any replications which are in progress.', verbose_name='Enabled')),
            ],
            options={
                'ordering': ['repl_filesystem'],
                'verbose_name': 'Replication Task',
                'verbose_name_plural': 'Replication Tasks',
            },
        ),
        migrations.CreateModel(
            name='ReplRemote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ssh_remote_hostname', models.CharField(max_length=120, verbose_name='Remote hostname')),
                ('ssh_remote_port', models.IntegerField(default=22, verbose_name='Remote port')),
                ('ssh_remote_dedicateduser_enabled', models.BooleanField(default=False, verbose_name='Remote Dedicated User Enabled')),
                ('ssh_remote_dedicateduser', freenasUI.freeadmin.models.fields.UserField(blank=True, default='', max_length=120, null=True, verbose_name='Remote Dedicated User')),
                ('ssh_remote_hostkey', models.CharField(max_length=2048, verbose_name='Remote hostkey')),
                ('ssh_cipher', models.CharField(choices=choices.REPL_CIPHER, default='standard', max_length=20, verbose_name='Encryption Cipher')),
            ],
            options={
                'verbose_name': 'Remote Replication Host',
                'verbose_name_plural': 'Remote Replication Hosts',
            },
        ),
        migrations.CreateModel(
            name='Scrub',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('scrub_threshold', models.PositiveSmallIntegerField(default=35, help_text='Determine how many days shall be between scrubs', verbose_name='Threshold days')),
                ('scrub_description', models.CharField(blank=True, max_length=200, verbose_name='Description')),
                ('scrub_minute', models.CharField(default='00', help_text='Values 0-59 allowed.', max_length=100, verbose_name='Minute')),
                ('scrub_hour', models.CharField(default='00', help_text='Values 0-23 allowed.', max_length=100, verbose_name='Hour')),
                ('scrub_daymonth', models.CharField(default='*', help_text='Values 1-31 allowed.', max_length=100, verbose_name='Day of month')),
                ('scrub_month', models.CharField(default='*', max_length=100, verbose_name='Month')),
                ('scrub_dayweek', models.CharField(default='7', max_length=100, verbose_name='Day of week')),
                ('scrub_enabled', models.BooleanField(default=True, verbose_name='Enabled')),
            ],
            options={
                'ordering': ['scrub_volume__vol_name'],
                'verbose_name': 'Scrub',
                'verbose_name_plural': 'Scrubs',
            },
        ),
        migrations.CreateModel(
            name='Task',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('task_filesystem', models.CharField(max_length=150, verbose_name='Volume/Dataset')),
                ('task_recursive', models.BooleanField(default=False, verbose_name='Recursive')),
                ('task_ret_count', models.PositiveIntegerField(default=2, verbose_name='Snapshot lifetime value')),
                ('task_ret_unit', models.CharField(choices=choices.RetentionUnit_Choices, default='week', max_length=120, verbose_name='Snapshot lifetime unit')),
                ('task_begin', models.TimeField(default=datetime.time(9, 0), help_text='Do not snapshot before', verbose_name='Begin')),
                ('task_end', models.TimeField(default=datetime.time(18, 0), help_text='Do not snapshot after', verbose_name='End')),
                ('task_interval', models.PositiveIntegerField(choices=choices.TASK_INTERVAL, default=60, help_text='How much time has been passed between two snapshot attempts.', verbose_name='Interval')),
                ('task_repeat_unit', models.CharField(choices=choices.RepeatUnit_Choices, default='weekly', help_text='How the task is repeated', max_length=120, verbose_name='Occurrence')),
                ('task_byweekday', models.CharField(blank=True, default='1,2,3,4,5', max_length=120, verbose_name='Weekday')),
                ('task_enabled', models.BooleanField(default=True, verbose_name='Enabled')),
            ],
            options={
                'ordering': ['task_filesystem'],
                'verbose_name': 'Periodic Snapshot Task',
                'verbose_name_plural': 'Periodic Snapshot Tasks',
            },
        ),
        migrations.CreateModel(
            name='VMWarePlugin',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hostname', models.CharField(max_length=200, verbose_name='Hostname')),
                ('username', models.CharField(help_text='Username on the above VMware host with enough privileges to snapshot virtual machines.', max_length=200, verbose_name='Username')),
                ('password', models.CharField(max_length=200, verbose_name='Password')),
                ('filesystem', models.CharField(max_length=200, verbose_name='ZFS Filesystem')),
                ('datastore', models.CharField(help_text='The datastore on the VMware side that the filesystem corresponds to.', max_length=200, verbose_name='Datastore')),
            ],
            options={
                'verbose_name': 'VMware-Snapshot',
                'verbose_name_plural': 'VMware-Snapshots',
            },
        ),
        migrations.CreateModel(
            name='Volume',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('vol_name', models.CharField(max_length=120, unique=True, verbose_name='Name')),
                ('vol_fstype', models.CharField(choices=[('ZFS', 'ZFS')], max_length=120, verbose_name='File System Type')),
                ('vol_guid', models.CharField(blank=True, editable=False, max_length=50)),
                ('vol_encrypt', models.IntegerField(choices=[(0, 'Unencrypted'), (1, 'Encrypted, no passphrase'), (2, 'Encrypted, with passphrase')], default=0, verbose_name='Encryption Type')),
                ('vol_encryptkey', models.CharField(blank=True, editable=False, max_length=50)),
            ],
            options={
                'verbose_name': 'Volume',
            },
        ),
        migrations.AddField(
            model_name='scrub',
            name='scrub_volume',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='storage.Volume', verbose_name='Volume'),
        ),
        migrations.AddField(
            model_name='replication',
            name='repl_remote',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='storage.ReplRemote', verbose_name='Remote Host'),
        ),
        migrations.AddField(
            model_name='encrypteddisk',
            name='encrypted_volume',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='storage.Volume'),
        ),
    ]
