# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-04-18 23:28
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import freenasUI.freeadmin.models.fields


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0003_add_ntlmv1_auth'),
    ]

    operations = [
        migrations.AlterField(
            model_name='s3',
            name='s3_access_key',
            field=models.CharField(blank=True, help_text='S3 username', max_length=128, null=True, verbose_name='Access key of 5 to 20 characters in length'),
        ),
        migrations.AlterField(
            model_name='s3',
            name='s3_bindport',
            field=models.SmallIntegerField(default=9000, help_text='TCP port on which to provide the S3 service (default 9000)', validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='Port'),
        ),
        migrations.AlterField(
            model_name='s3',
            name='s3_browser',
            field=models.BooleanField(default=False, help_text='Enable the web user interface for the S3 service', verbose_name='Enable Browser'),
        ),
        migrations.AlterField(
            model_name='s3',
            name='s3_disks',
            field=freenasUI.freeadmin.models.fields.PathField(blank=True, help_text='S3 filesystem directory', max_length=255, null=True, verbose_name='Disks'),
        ),
        migrations.AlterField(
            model_name='s3',
            name='s3_mode',
            field=models.CharField(choices=[('local', 'local'), ('distributed', 'distributed')], default='local', help_text="This doesn't do anything yet", max_length=120, verbose_name='Mode'),
        ),
        migrations.AlterField(
            model_name='s3',
            name='s3_secret_key',
            field=models.CharField(blank=True, help_text='S3 password', max_length=128, null=True, verbose_name='Secret key of 8 to 40 characters in length'),
        ),
    ]
