# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-02-21 13:18
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import sys


def add_s3_to_services(apps, schema_editor):
    services = apps.get_model("services", "services")
    s3 = services.objects.create()
    s3.srv_service = "s3"
    s3.srv_enable = False
    try:
        s3.save()
    except Exception as error:
        print(f"ERROR: unable to add S3 service: {error}", file=sys.stderr)


def remove_s3_from_services(apps, schema_editor):
    services = apps.get_model("services", "services")
    s3 = services.objects.get(srv_service="s3")
    try:
        s3.delete()
    except Exception as error:
        print(f"ERROR: unable to remove S3 service: {error}", file=sys.stderr)


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='S3',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('s3_bindip', models.CharField(blank=True, help_text='Select the IP address to listen to for S3 requests. If left unchecked, S3 will listen on all available addresses', max_length=128, verbose_name='IP Address')),
                ('s3_bindport', models.SmallIntegerField(default=9000, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(65535)], verbose_name='Port')),
                ('s3_access_key', models.CharField(blank=True, help_text='S3 username', max_length=128, null=True, verbose_name='Access Key')),
                ('s3_secret_key', models.CharField(blank=True, help_text='S3 password', max_length=128, null=True, verbose_name='Secret Key')),
                ('s3_browser', models.BooleanField(default=False, help_text='This will enable the web UI for the S3 service.', verbose_name='Enable Browser')),
                ('s3_mode', models.CharField(choices=[(b'local', 'local'), (b'distributed', 'distributed')], default=b'local', max_length=120, verbose_name='Mode')),
                ('s3_disks', models.CharField(blank=False, help_text='S3 filesystem disk(s)', max_length=8192, null=True, verbose_name='Disks')),
            ],
            options={
                'verbose_name': 'S3',
                'verbose_name_plural': 'S3',
            },
        ),
        migrations.RunPython(
            add_s3_to_services,
            reverse_code=remove_s3_from_services
        )
    ]
