# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-04-22 13:28
from __future__ import unicode_literals

from django.db import migrations

import re

RE_MTU = re.compile(r'\bmtu \d+\b')


def lagg_mtu(apps, schema_editor):
    Interfaces = apps.get_model('network', 'Interfaces')
    for i in Interfaces.objects.filter(int_interface__startswith='lagg'):
        reg = RE_MTU.search(i.int_options)
        if reg:
            for member in i.lagginterface.lagginterfacemembers_set.all():
                member.lagg_deviceoptions += f' {reg.group(0)}'
                member.save()
            i.int_options = re.sub(RE_MTU, '', i.int_options)
            i.save()


class Migration(migrations.Migration):

    dependencies = [
        ('network', '0002_lagg_fec'),
    ]

    operations = [
        migrations.RunPython(lagg_mtu, reverse_code=migrations.RunPython.noop),
    ]
