# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2016-12-27 21:42


import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import freenasUI.contrib.IPAddressField
from freenasUI import choices


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Alias',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('alias_vip', freenasUI.contrib.IPAddressField.IP4AddressField(blank=True, default='', verbose_name='Virtual IPv4')),
                ('alias_v4address', freenasUI.contrib.IPAddressField.IP4AddressField(blank=True, default='', verbose_name='IPv4 Address')),
                ('alias_v4address_b', freenasUI.contrib.IPAddressField.IP4AddressField(blank=True, default='', verbose_name='IPv4 Address')),
                ('alias_v4netmaskbit', models.CharField(blank=True, choices=choices.v4NetmaskBitList, default='', help_text='', max_length=3, verbose_name='IPv4 Netmask')),
                ('alias_v6address', freenasUI.contrib.IPAddressField.IP6AddressField(blank=True, default='', verbose_name='IPv6 Address')),
                ('alias_v6address_b', freenasUI.contrib.IPAddressField.IP6AddressField(blank=True, default='', verbose_name='IPv6 Address')),
                ('alias_v6netmaskbit', models.CharField(blank=True, choices=choices.v6NetmaskBitList, default='', help_text='', max_length=3, verbose_name='IPv6 Prefix Length')),
            ],
            options={
                'verbose_name': 'Alias',
                'verbose_name_plural': 'Aliases',
            },
        ),
        migrations.CreateModel(
            name='GlobalConfiguration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('gc_hostname', models.CharField(default='nas', max_length=120, validators=[django.core.validators.RegexValidator(regex='^[a-zA-Z\\.\\-\\_0-9]+$')], verbose_name='Hostname')),
                ('gc_hostname_b', models.CharField(blank=True, max_length=120, null=True, validators=[django.core.validators.RegexValidator(regex='^[a-zA-Z\\.\\-\\_0-9]+$')], verbose_name='Hostname')),
                ('gc_domain', models.CharField(default='local', max_length=120, validators=[django.core.validators.RegexValidator(regex='^[a-zA-Z\\.\\-\\_0-9]+$')], verbose_name='Domain')),
                ('gc_ipv4gateway', freenasUI.contrib.IPAddressField.IP4AddressField(blank=True, default='', verbose_name='IPv4 Default Gateway')),
                ('gc_ipv6gateway', freenasUI.contrib.IPAddressField.IP6AddressField(blank=True, default='', verbose_name='IPv6 Default Gateway')),
                ('gc_nameserver1', freenasUI.contrib.IPAddressField.IPAddressField(blank=True, default='', verbose_name='Nameserver 1')),
                ('gc_nameserver2', freenasUI.contrib.IPAddressField.IPAddressField(blank=True, default='', verbose_name='Nameserver 2')),
                ('gc_nameserver3', freenasUI.contrib.IPAddressField.IPAddressField(blank=True, default='', verbose_name='Nameserver 3')),
                ('gc_httpproxy', models.CharField(blank=True, max_length=255, verbose_name='HTTP Proxy')),
                ('gc_netwait_enabled', models.BooleanField(default=False, help_text='If enabled, delays the start of network-reliant services until interface is up and ICMP packets to a destination defined in netwait ip list are flowing.  Link state is examined first, followed by "pinging" an IP address to verify network usability.  If no destination can be reached or timeouts are exceeded, network services are started anyway with no guarantee that the network is usable.', verbose_name='Enable netwait feature')),
                ('gc_netwait_ip', models.CharField(blank=True, help_text='Space-delimited list of IP addresses to ping(8). If multiple IP addresses are specified, each will be tried until one is successful or the list is exhausted. If it is empty the default gateway will be used.', max_length=300, verbose_name='Netwait IP list')),
                ('gc_hosts', models.TextField(blank=True, default='', help_text='This field is appended to /etc/hosts which contains information regarding known hosts on the network. hosts(5)', verbose_name='Host name data base')),
            ],
            options={
                'verbose_name': 'Global Configuration',
                'verbose_name_plural': 'Global Configuration',
            },
        ),
        migrations.CreateModel(
            name='Interfaces',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('int_interface', models.CharField(help_text='Pick your NIC', max_length=300, verbose_name='NIC')),
                ('int_name', models.CharField(help_text='Name your NIC.', max_length=120, verbose_name='Interface Name')),
                ('int_dhcp', models.BooleanField(default=False, help_text='When enabled, use DHCP to obtain IPv4 address as well as default router, etc.', verbose_name='DHCP')),
                ('int_ipv4address', freenasUI.contrib.IPAddressField.IPAddressField(blank=True, default='', verbose_name='IPv4 Address')),
                ('int_ipv4address_b', freenasUI.contrib.IPAddressField.IPAddressField(blank=True, default='', verbose_name='IPv4 Address')),
                ('int_v4netmaskbit', models.CharField(blank=True, choices=choices.v4NetmaskBitList, default='', help_text='', max_length=3, verbose_name='IPv4 Netmask')),
                ('int_ipv6auto', models.BooleanField(default=False, help_text='When enabled, automatically configurate IPv6 address via rtsol(8).', verbose_name='Auto configure IPv6')),
                ('int_ipv6address', freenasUI.contrib.IPAddressField.IPAddressField(blank=True, default='', verbose_name='IPv6 Address')),
                ('int_v6netmaskbit', models.CharField(blank=True, choices=choices.v6NetmaskBitList, default='', help_text='', max_length=4, verbose_name='IPv6 Prefix Length')),
                ('int_vip', freenasUI.contrib.IPAddressField.IPAddressField(blank=True, null=True, verbose_name='Virtual IP')),
                ('int_vhid', models.PositiveIntegerField(blank=True, null=True, verbose_name='Virtual Host ID')),
                ('int_pass', models.CharField(blank=True, editable=False, max_length=100, verbose_name='Password')),
                ('int_critical', models.BooleanField(default=False, verbose_name='Critical for Failover')),
                ('int_group', models.IntegerField(blank=True, choices=[(1, 1), (2, 2), (3, 3), (4, 4), (5, 5), (6, 6), (7, 7), (8, 8), (9, 9), (10, 10), (11, 11), (12, 12), (13, 13), (14, 14), (15, 15), (16, 16), (17, 17), (18, 18), (19, 19), (20, 20), (21, 21), (22, 22), (23, 23), (24, 24), (25, 25), (26, 26), (27, 27), (28, 28), (29, 29), (30, 30), (31, 31), (32, 32)], null=True, verbose_name='Group')),
                ('int_options', models.CharField(blank=True, max_length=120, verbose_name='Options')),
            ],
            options={
                'ordering': ['int_interface'],
                'verbose_name': 'Interface',
                'verbose_name_plural': 'Interfaces',
            },
        ),
        migrations.CreateModel(
            name='LAGGInterface',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lagg_protocol', models.CharField(choices=choices.LAGGType, max_length=120, verbose_name='Protocol Type')),
                ('lagg_interface', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='network.Interfaces', verbose_name='Interface')),
            ],
            options={
                'ordering': ['lagg_interface'],
                'verbose_name': 'Link Aggregation',
                'verbose_name_plural': 'Link Aggregations',
            },
        ),
        migrations.CreateModel(
            name='LAGGInterfaceMembers',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lagg_ordernum', models.IntegerField(verbose_name='LAGG Priority Number')),
                ('lagg_physnic', models.CharField(max_length=120, unique=True, verbose_name='Physical NIC')),
                ('lagg_deviceoptions', models.CharField(max_length=120, verbose_name='Options')),
                ('lagg_interfacegroup', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='network.LAGGInterface', verbose_name='LAGG Interface Group')),
            ],
            options={
                'ordering': ['lagg_interfacegroup'],
                'verbose_name': 'Link Aggregation Member',
                'verbose_name_plural': 'Link Aggregation Members',
            },
        ),
        migrations.CreateModel(
            name='StaticRoute',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sr_destination', models.CharField(max_length=120, verbose_name='Destination network')),
                ('sr_gateway', freenasUI.contrib.IPAddressField.IP4AddressField(max_length=120, verbose_name='Gateway')),
                ('sr_description', models.CharField(blank=True, max_length=120, verbose_name='Description')),
            ],
            options={
                'ordering': ['sr_destination', 'sr_gateway'],
                'verbose_name': 'Static Route',
                'verbose_name_plural': 'Static Routes',
            },
        ),
        migrations.CreateModel(
            name='VLAN',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('vlan_vint', models.CharField(help_text='Interface names must be vlanX where X is a number. Example: vlan0.', max_length=120, verbose_name='Virtual Interface')),
                ('vlan_pint', models.CharField(max_length=300, verbose_name='Physical Interface')),
                ('vlan_tag', models.PositiveIntegerField(verbose_name='VLAN Tag')),
                ('vlan_description', models.CharField(blank=True, max_length=120, verbose_name='Description')),
            ],
            options={
                'ordering': ['vlan_vint'],
                'verbose_name': 'VLAN',
                'verbose_name_plural': 'VLANs',
            },
        ),
        migrations.AddField(
            model_name='alias',
            name='alias_interface',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='network.Interfaces', verbose_name='Interface'),
        ),
    ]
