# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2016-12-27 21:41


from django.db import migrations, models
import django.db.models.deletion
import freenasUI.freeadmin.models.fields
from freenasUI import choices


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('system', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ActiveDirectory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ad_domainname', models.CharField(help_text='Domain Name, eg example.com', max_length=120, verbose_name='Domain Name (DNS/Realm-Name)')),
                ('ad_bindname', models.CharField(blank=True, help_text='Domain account name to bind as', max_length=120, verbose_name='Domain Account Name')),
                ('ad_bindpw', models.CharField(blank=True, help_text='Domain Account password.', max_length=120, verbose_name='Domain Account Password')),
                ('ad_ssl', models.CharField(choices=choices.LDAP_SSL_CHOICES, default='off', help_text='This parameter specifies whether to use SSL/TLS, e.g. on/off/start_tls', max_length=120, verbose_name='Encryption Mode')),
                ('ad_verbose_logging', models.BooleanField(default=False, verbose_name='Verbose logging')),
                ('ad_unix_extensions', models.BooleanField(default=False, help_text='Set this if your Active Directory has UNIX extensions.', verbose_name='UNIX extensions')),
                ('ad_allow_trusted_doms', models.BooleanField(default=False, help_text='Set this if you want to allow Trusted Domains.', verbose_name='Allow Trusted Domains')),
                ('ad_use_default_domain', models.BooleanField(default=False, help_text='Set this if you want to use the default domain for users and groups.', verbose_name='Use Default Domain')),
                ('ad_allow_dns_updates', models.BooleanField(default=True, help_text='Set this if you want to allow allow DNS updates.', verbose_name='Allow DNS updates')),
                ('ad_disable_freenas_cache', models.BooleanField(default=False, help_text='Set this if you want to disable caching Active Directory users and groups.  Use this option if you are experiencing slowness or having difficulty binding to the domain with a large number of users and groups.', verbose_name='Disable Active Directory user/group cache')),
                ('ad_userdn', models.CharField(blank=True, help_text='DN of the user container in AD.', max_length=1024, null=True, verbose_name='User Base')),
                ('ad_groupdn', models.CharField(blank=True, help_text='DN of the group container in AD.', max_length=1024, null=True, verbose_name='Group Base')),
                ('ad_site', models.CharField(blank=True, help_text='Name of site to use.', max_length=120, null=True, verbose_name='Site Name')),
                ('ad_dcname', models.CharField(blank=True, help_text='FQDN of the domain controller to use.', max_length=120, null=True, verbose_name='Domain Controller')),
                ('ad_gcname', models.CharField(blank=True, help_text='FQDN of the global catalog server to use.', max_length=120, null=True, verbose_name='Global Catalog Server')),
                ('ad_timeout', models.IntegerField(default=60, help_text='Timeout for AD related commands.', verbose_name='AD timeout')),
                ('ad_dns_timeout', models.IntegerField(default=60, help_text='Timeout for AD DNS queries.', verbose_name='DNS timeout')),
                ('ad_idmap_backend', models.CharField(choices=choices.IDMAP_CHOICES, default='rid', help_text='Idmap backend for winbind.', max_length=120, verbose_name='Idmap backend')),
                ('ad_nss_info', models.CharField(blank=True, choices=choices.NSS_INFO_CHOICES, help_text="This parameter is designed to control how Winbind retrieves Name Service Information to construct a user's home directory and login", max_length=120, null=True, verbose_name='Winbind NSS Info')),
                ('ad_ldap_sasl_wrapping', models.CharField(choices=choices.LDAP_SASL_WRAPPING_CHOICES, default='plain', help_text='The client ldap sasl wrapping defines whether ldap traffic will be signed or signed and encrypted (sealed).This option is needed in the case of Domain Controllers enforcing the usage of signed LDAP connections (e.g. Windows 2000 SP3 or higher). LDAP sign and seal can be controlled with the registry key "HKLM\\System\\CurrentControlSet\\Services\\NTDS\\Parameters\\LDAPServerIntegrity" on the Windows server side.', max_length=120, verbose_name='SASL wrapping')),
                ('ad_enable', models.BooleanField(default=False, verbose_name='Enable')),
                ('ad_certificate', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='system.CertificateAuthority', verbose_name='Certificate')),
                ('ad_enable_monitor', models.BooleanField(default=False, help_text='Restarts AD automatically if the service is disconnected', verbose_name='Enable Monitoring')),
                ('ad_monitor_frequency', models.IntegerField(default=60, help_text='How often to verify that AD servers are active', validators=[django.core.validators.MaxValueValidator(3600), django.core.validators.MinValueValidator(30)], verbose_name='AD check connectivity frequency (seconds)')),
                ('ad_recover_retry', models.IntegerField(default=10, help_text='How many times we will try to recover the connection with AD server, if the value is 0, it will try forever', validators=[django.core.validators.MaxValueValidator(500), django.core.validators.MinValueValidator(1)], verbose_name='How many recovery attempts')),
            ],
            options={
                'verbose_name': 'Active Directory',
                'verbose_name_plural': 'Active Directory',
            },
        ),
        migrations.CreateModel(
            name='idmap_ad',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idmap_ds_type', models.IntegerField(null=True)),
                ('idmap_ds_id', models.PositiveIntegerField(null=True)),
                ('idmap_ad_range_low', models.IntegerField(default=10000, verbose_name='Range Low')),
                ('idmap_ad_range_high', models.IntegerField(default=90000000, verbose_name='Range High')),
                ('idmap_ad_schema_mode', models.CharField(choices=[('rfc2307', 'rfc2307'), ('sfu', 'sfu'), ('sfu20', 'sfu20')], default='rfc2307', help_text='Defines the schema that idmap_ad should use when querying Active Directory regarding user and group information. This can be either the RFC2307 schema support included in Windows 2003 R2 or the Service for Unix (SFU) schema. For SFU 3.0 or 3.5 please choose "sfu", for SFU 2.0 please choose "sfu20". Please note that primary group membership is currently always calculated via the "primaryGroupID" LDAP attribute.', max_length=120, verbose_name='Schema Mode')),
            ],
            options={
                'verbose_name': 'AD Idmap',
                'verbose_name_plural': 'AD Idmap',
            },
        ),
        migrations.CreateModel(
            name='idmap_adex',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idmap_ds_type', models.IntegerField(null=True)),
                ('idmap_ds_id', models.PositiveIntegerField(null=True)),
                ('idmap_adex_range_low', models.IntegerField(default=10000, verbose_name='Range Low')),
                ('idmap_adex_range_high', models.IntegerField(default=90000000, verbose_name='Range High')),
            ],
            options={
                'verbose_name': 'ADEX Idmap',
                'verbose_name_plural': 'ADEX Idmap',
            },
        ),
        migrations.CreateModel(
            name='idmap_autorid',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idmap_ds_type', models.IntegerField(null=True)),
                ('idmap_ds_id', models.PositiveIntegerField(null=True)),
                ('idmap_autorid_range_low', models.IntegerField(default=10000, verbose_name='Range Low')),
                ('idmap_autorid_range_high', models.IntegerField(default=90000000, verbose_name='Range High')),
                ('idmap_autorid_rangesize', models.IntegerField(default=100000, help_text='Defines the number of uids/gids available per domain range. The minimum needed value is 2000. SIDs with RIDs larger than this value will be mapped into extension ranges depending upon number of available ranges. If the autorid backend runs out of available ranges, mapping requests for new domains (or new extension ranges for domains already known) are ignored and the corresponding map is discarded.', verbose_name='Range Size')),
                ('idmap_autorid_readonly', models.BooleanField(default=False, help_text='Turn the module into read-only mode. No new ranges will be allocated nor will new mappings be created in the idmap pool.', verbose_name='Read Only')),
                ('idmap_autorid_ignore_builtin', models.BooleanField(default=False, help_text='Ignore any mapping requests for the BUILTIN domain.', verbose_name='Ignore Builtin')),
            ],
            options={
                'verbose_name': 'AutoRID Idmap',
                'verbose_name_plural': 'AutoRID Idmap',
            },
        ),
        migrations.CreateModel(
            name='idmap_hash',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idmap_ds_type', models.IntegerField(null=True)),
                ('idmap_ds_id', models.PositiveIntegerField(null=True)),
                ('idmap_hash_range_low', models.IntegerField(default=90000001, verbose_name='Range Low')),
                ('idmap_hash_range_high', models.IntegerField(default=100000000, verbose_name='Range High')),
                ('idmap_hash_range_name_map', freenasUI.freeadmin.models.fields.PathField(help_text='Specifies the absolute path to the name mapping file used by the nss_info API. Entries in the file are of the form "unix name = qualified domain name". Mapping of both user and group names is supported.', max_length=255, verbose_name='Name Map')),
            ],
            options={
                'verbose_name': 'Hash Idmap',
                'verbose_name_plural': 'Hash Idmap',
            },
        ),
        migrations.CreateModel(
            name='idmap_ldap',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idmap_ds_type', models.IntegerField(null=True)),
                ('idmap_ds_id', models.PositiveIntegerField(null=True)),
                ('idmap_ldap_range_low', models.IntegerField(default=10000, verbose_name='Range Low')),
                ('idmap_ldap_range_high', models.IntegerField(default=90000000, verbose_name='Range High')),
                ('idmap_ldap_ldap_base_dn', models.CharField(blank=True, help_text='Defines the directory base suffix to use for SID/uid/gid mapping entries. If not defined, idmap_ldap will default to using the "ldap idmap suffix" option from smb.conf.', max_length=120, verbose_name='Base DN')),
                ('idmap_ldap_ldap_user_dn', models.CharField(blank=True, help_text='Defines the user DN to be used for authentication. The secret for authenticating this user should be stored with net idmap secret (see net(8)). If absent, the ldap credentials from the ldap passdb configuration are used, and if these are also absent, an anonymous bind will be performed as last fallback.', max_length=120, verbose_name='User DN')),
                ('idmap_ldap_ldap_url', models.CharField(help_text='Specifies the LDAP server to use for SID/uid/gid map entries.', max_length=255, verbose_name='URL')),
                ('idmap_ldap_ssl', models.CharField(choices=choices.LDAP_SSL_CHOICES, default='off', help_text='This parameter specifies whether to use SSL/TLS, e.g. on/off/start_tls', max_length=120, verbose_name='Encryption Mode')),
                ('idmap_ldap_certificate', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='system.CertificateAuthority', verbose_name='Certificate')),
            ],
            options={
                'verbose_name': 'LDAP Idmap',
                'verbose_name_plural': 'LDAP Idmap',
            },
        ),
        migrations.CreateModel(
            name='idmap_nss',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idmap_ds_type', models.IntegerField(null=True)),
                ('idmap_ds_id', models.PositiveIntegerField(null=True)),
                ('idmap_nss_range_low', models.IntegerField(default=10000, verbose_name='Range Low')),
                ('idmap_nss_range_high', models.IntegerField(default=90000000, verbose_name='Range High')),
            ],
            options={
                'verbose_name': 'NSS Idmap',
                'verbose_name_plural': 'NSS Idmap',
            },
        ),
        migrations.CreateModel(
            name='idmap_rfc2307',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idmap_ds_type', models.IntegerField(null=True)),
                ('idmap_ds_id', models.PositiveIntegerField(null=True)),
                ('idmap_rfc2307_range_low', models.IntegerField(default=10000, verbose_name='Range Low')),
                ('idmap_rfc2307_range_high', models.IntegerField(default=90000000, verbose_name='Range High')),
                ('idmap_rfc2307_ldap_server', models.CharField(choices=[('ad', 'ad'), ('stand-alone', 'stand-alone')], default='ad', help_text='Defines the type of LDAP server to use. This can either be the LDAP server provided by the Active Directory server (ad) or a stand-alone LDAP server.', max_length=120, verbose_name='LDAP Server')),
                ('idmap_rfc2307_bind_path_user', models.CharField(help_text='Specifies the bind path where user objects can be found in the LDAP server.', max_length=120, verbose_name='User Bind Path')),
                ('idmap_rfc2307_bind_path_group', models.CharField(help_text='Specifies the bind path where group objects can be found in the LDAP server.', max_length=120, verbose_name='Group Bind Path')),
                ('idmap_rfc2307_user_cn', models.BooleanField(default=False, help_text='Query cn attribute instead of uid attribute for the user name in LDAP.', verbose_name='User CN')),
                ('idmap_rfc2307_cn_realm', models.BooleanField(default=False, help_text='Append @realm to cn for groups (and users if user_cn is set) in LDAP.', verbose_name='CN Realm')),
                ('idmap_rfc2307_ldap_domain', models.CharField(blank=True, help_text='When using the LDAP server in the Active Directory server, this allows to specify the domain where to access the Active Directory server. This allows using trust relationships while keeping all RFC 2307 records in one place. This parameter is optional, the default is to access the AD server in the current domain to query LDAPrecords.', max_length=120, verbose_name='LDAP Domain')),
                ('idmap_rfc2307_ldap_url', models.CharField(blank=True, help_text='When using a stand-alone LDAP server, this parameter specifies the ldap URL for accessing the LDAP server.', max_length=255, verbose_name='LDAP URL')),
                ('idmap_rfc2307_ldap_user_dn', models.CharField(blank=True, help_text='Defines the user DN to be used for authentication. The secret for authenticating this user should be stored with net idmap secret (see net(8)). If absent, an anonymous bind will be performed.', max_length=120, verbose_name='LDAP User DN')),
                ('idmap_rfc2307_ldap_user_dn_password', models.CharField(blank=True, help_text='Password for LDAP User DN', max_length=120, verbose_name='LDAP User DN Password')),
                ('idmap_rfc2307_ldap_realm', models.CharField(blank=True, help_text='Defines the realm to use in the user and group names. This is only required when using cn_realm together with a stand-alone ldap server.', max_length=120, verbose_name='LDAP Realm')),
                ('idmap_rfc2307_ssl', models.CharField(choices=choices.LDAP_SSL_CHOICES, default='off', help_text='This parameter specifies whether to use SSL/TLS, e.g. on/off/start_tls', max_length=120, verbose_name='Encryption Mode')),
                ('idmap_rfc2307_certificate', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='system.CertificateAuthority', verbose_name='Certificate')),
            ],
            options={
                'verbose_name': 'RFC2307 Idmap',
                'verbose_name_plural': 'RFC2307 Idmap',
            },
        ),
        migrations.CreateModel(
            name='idmap_rid',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idmap_ds_type', models.IntegerField(null=True)),
                ('idmap_ds_id', models.PositiveIntegerField(null=True)),
                ('idmap_rid_range_low', models.IntegerField(default=20000, verbose_name='Range Low')),
                ('idmap_rid_range_high', models.IntegerField(default=90000000, verbose_name='Range High')),
            ],
            options={
                'verbose_name': 'RID Idmap',
                'verbose_name_plural': 'RID Idmap',
            },
        ),
        migrations.CreateModel(
            name='idmap_tdb',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idmap_ds_type', models.IntegerField(null=True)),
                ('idmap_ds_id', models.PositiveIntegerField(null=True)),
                ('idmap_tdb_range_low', models.IntegerField(default=90000001, verbose_name='Range Low')),
                ('idmap_tdb_range_high', models.IntegerField(default=100000000, verbose_name='Range High')),
            ],
            options={
                'verbose_name': 'TDB Idmap',
                'verbose_name_plural': 'TDB Idmap',
            },
        ),
        migrations.CreateModel(
            name='idmap_tdb2',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idmap_ds_type', models.IntegerField(null=True)),
                ('idmap_ds_id', models.PositiveIntegerField(null=True)),
                ('idmap_tdb2_range_low', models.IntegerField(default=90000001, verbose_name='Range Low')),
                ('idmap_tdb2_range_high', models.IntegerField(default=100000000, verbose_name='Range High')),
                ('idmap_tdb2_script', freenasUI.freeadmin.models.fields.PathField(help_text='This option can be used to configure an external program for performing id mappings instead of using the tdb counter. The mappings are then stored int tdb2 idmap database.', max_length=255, verbose_name='Script')),
            ],
            options={
                'verbose_name': 'TDB2 Idmap',
                'verbose_name_plural': 'TDB2 Idmap',
            },
        ),
        migrations.CreateModel(
            name='KerberosKeytab',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('keytab_name', models.CharField(help_text='Descriptive Name.', max_length=120, unique=True, verbose_name='Name')),
                ('keytab_file', models.TextField(help_text='Kerberos keytab file', verbose_name='Keytab')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='KerberosPrincipal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('principal_version', models.IntegerField(default=-1, verbose_name='Version number')),
                ('principal_encryption', models.CharField(max_length=120, verbose_name='Encryption algorithm')),
                ('principal_name', models.CharField(max_length=120, verbose_name='Principal name')),
                ('principal_timestamp', models.DateTimeField(verbose_name='Date')),
                ('principal_keytab', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='directoryservice.KerberosKeytab', verbose_name='Keytab')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='KerberosRealm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('krb_realm', models.CharField(help_text='Kerberos realm.', max_length=120, unique=True, verbose_name='Realm')),
                ('krb_kdc', models.CharField(blank=True, help_text='KDC for this realm.', max_length=120, verbose_name='KDC')),
                ('krb_admin_server', models.CharField(blank=True, help_text='Specifies the admin server for this realm, where all the modifications to the database are performed.', max_length=120, verbose_name='Admin Server')),
                ('krb_kpasswd_server', models.CharField(blank=True, help_text='Points to the server where all the password changes are performed.  If there is no such entry, the kpasswd port on the admin_server host will be tried.', max_length=120, verbose_name='Password Server')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='KerberosSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ks_appdefaults_aux', models.TextField(blank=True, verbose_name='Appdefaults auxiliary parameters')),
                ('ks_libdefaults_aux', models.TextField(blank=True, verbose_name='Libdefaults auxiliary parameters')),
            ],
            options={
                'verbose_name': 'Kerberos Settings',
                'verbose_name_plural': 'Kerberos Settings',
            },
        ),
        migrations.CreateModel(
            name='LDAP',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('ldap_hostname', models.CharField(blank=True, help_text='The name or IP address of the LDAP server', max_length=120, verbose_name='Hostname')),
                ('ldap_basedn', models.CharField(blank=True, help_text='The default base Distinguished Name (DN) to use for searches, eg dc=test,dc=org', max_length=120, verbose_name='Base DN')),
                ('ldap_binddn', models.CharField(blank=True, help_text='The distinguished name with which to bind to the directory server, e.g. cn=admin,dc=test,dc=org', max_length=256, verbose_name='Bind DN')),
                ('ldap_bindpw', models.CharField(blank=True, help_text='The credentials with which to bind.', max_length=120, verbose_name='Bind password')),
                ('ldap_anonbind', models.BooleanField(default=False, verbose_name='Allow Anonymous Binding')),
                ('ldap_usersuffix', models.CharField(blank=True, help_text='This parameter specifies the suffix that is used for users when these are added to the LDAP directory, e.g. ou=Users', max_length=120, verbose_name='User Suffix')),
                ('ldap_groupsuffix', models.CharField(blank=True, help_text='This parameter specifies the suffix that is used for groups when these are added to the LDAP directory, e.g. ou=Groups', max_length=120, verbose_name='Group Suffix')),
                ('ldap_passwordsuffix', models.CharField(blank=True, help_text='This parameter specifies the suffix that is used for passwords when these are added to the LDAP directory, e.g. ou=Passwords', max_length=120, verbose_name='Password Suffix')),
                ('ldap_machinesuffix', models.CharField(blank=True, help_text='This parameter specifies the suffix that is used for machines when these are added to the LDAP directory, e.g. ou=Computers', max_length=120, verbose_name='Machine Suffix')),
                ('ldap_sudosuffix', models.CharField(blank=True, help_text='This parameter specifies the suffix that is used for the SUDO configuration in the LDAP directory, e.g. ou=SUDOers', max_length=120, verbose_name='SUDO Suffix')),
                ('ldap_ssl', models.CharField(choices=choices.LDAP_SSL_CHOICES, default='off', help_text='This parameter specifies whether to use SSL/TLS, e.g. on/off/start_tls', max_length=120, verbose_name='Encryption Mode')),
                ('ldap_timeout', models.IntegerField(default=10, help_text='Timeout for LDAP related commands.', verbose_name='LDAP timeout')),
                ('ldap_dns_timeout', models.IntegerField(default=10, help_text='Timeout for LDAP DNS queries.', verbose_name='DNS timeout')),
                ('ldap_idmap_backend', models.CharField(choices=choices.IDMAP_CHOICES, default='ldap', help_text='Idmap backend for winbind.', max_length=120, verbose_name='Idmap Backend')),
                ('ldap_has_samba_schema', models.BooleanField(default=False, verbose_name='Samba Schema')),
                ('ldap_auxiliary_parameters', models.TextField(blank=True, help_text='These parameters are added to sssd.conf', verbose_name='Auxiliary Parameters')),
                ('ldap_schema', models.CharField(choices=choices.LDAP_SCHEMA_CHOICES, default='rfc2307', help_text='LDAP Schema type.', max_length=120, verbose_name='Schema')),
                ('ldap_enable', models.BooleanField(default=False, verbose_name='Enable')),
                ('ldap_certificate', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='system.CertificateAuthority', verbose_name='Certificate')),
                ('ldap_kerberos_principal', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='directoryservice.KerberosPrincipal', verbose_name='Kerberos Principal')),
                ('ldap_kerberos_realm', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='directoryservice.KerberosRealm', verbose_name='Kerberos Realm')),
            ],
            options={
                'verbose_name': 'LDAP',
                'verbose_name_plural': 'LDAP',
            },
        ),
        migrations.CreateModel(
            name='NIS',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nis_domain', models.CharField(help_text='NIS domain name', max_length=120, verbose_name='NIS domain')),
                ('nis_servers', models.CharField(blank=True, help_text='Comma delimited list of NIS servers', max_length=8192, verbose_name='NIS servers')),
                ('nis_secure_mode', models.BooleanField(default=False, help_text='Cause ypbind to run in secure mode', verbose_name='Secure mode')),
                ('nis_manycast', models.BooleanField(default=False, help_text="Cause ypbind to use 'many-cast' instead of broadcast", verbose_name='Manycast')),
                ('nis_enable', models.BooleanField(default=False, verbose_name='Enable')),
            ],
            options={
                'verbose_name': 'NIS Domain',
                'verbose_name_plural': 'NIS Domain',
            },
        ),
        migrations.CreateModel(
            name='NT4',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nt4_dcname', models.CharField(help_text='FQDN of the domain controller to use.', max_length=120, verbose_name='Domain Controller')),
                ('nt4_workgroup', models.CharField(help_text='Workgroup or domain name in old format, eg WORKGROUP', max_length=120, verbose_name='Workgroup Name')),
                ('nt4_adminname', models.CharField(help_text='Domain administrator account name', max_length=120, verbose_name='Administrator Name')),
                ('nt4_adminpw', models.CharField(help_text='Domain administrator account password.', max_length=120, verbose_name='Administrator Password')),
                ('nt4_use_default_domain', models.BooleanField(default=False, help_text='Set this if you want to use the default domain for users and groups.', verbose_name='Use Default Domain')),
                ('nt4_idmap_backend', models.CharField(choices=choices.IDMAP_CHOICES, default='rid', help_text='Idmap backend for winbind.', max_length=120, verbose_name='Idmap backend')),
                ('nt4_enable', models.BooleanField(default=False, verbose_name='Enable')),
            ],
            options={
                'verbose_name': 'NT4 Domain',
                'verbose_name_plural': 'NT4 Domain',
            },
        ),
        migrations.AddField(
            model_name='activedirectory',
            name='ad_kerberos_principal',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='directoryservice.KerberosPrincipal', verbose_name='Kerberos Principal'),
        ),
        migrations.AddField(
            model_name='activedirectory',
            name='ad_kerberos_realm',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='directoryservice.KerberosRealm', verbose_name='Kerberos Realm'),
        ),
    ]
